#include <bits/stdc++.h>
using namespace std;
typedef long long ll;

struct square
{
    ll x, y, z;
};
const ll N = 510;
ll h, w;
char a[N][N];
ll dp[N][N][6], cc[N][N][6], M = 1e15;
queue<square> q;

bool valid(int x, int y)
{   return x>0 && y>0 && x<=h && y<=w && a[x][y]!='#';  }

square ms(int x, int y, int z)
{   square t; t.x=x; t.y=y; t.z=z; return t;    }

void king(int x, int y, ll v)
{
    for(int i=-1;i<=1;i++)
        for(int j=-1;j<=1;j++)
            if(valid(x+i,y+j) && dp[x+i][y+j][1]>v)
                dp[x+i][y+j][1]=v, q.push(ms(x+i,y+j,1));
}
void bishop(int x, int y, ll v, int z)
{
    int xx=x, yy=y;
    while(valid(x+1,y+1)) {
        x++; y++;
        if(dp[x][y][z]>v) dp[x][y][z]=v, q.push(ms(x,y,z));
    }
    x=xx, y=yy;
    while(valid(x+1,y-1)) {
        x++; y--;
        if(dp[x][y][z]>v) dp[x][y][z]=v, q.push(ms(x,y,z));
    }
    x=xx, y=yy;
    while(valid(x-1,y+1)) {
        x--; y++;
        if(dp[x][y][z]>v) dp[x][y][z]=v, q.push(ms(x,y,z));
    }
    x=xx, y=yy;
    while(valid(x-1,y-1)) {
        x--; y--;
        if(dp[x][y][z]>v) dp[x][y][z]=v, q.push(ms(x,y,z));
    }
}
void rook(int x, int y, ll v, int z)
{
    int xx=x, yy=y;
    while(valid(x+1,y)) {
        x++;
        if(dp[x][y][z]>v) dp[x][y][z]=v, q.push(ms(x,y,z));
    }
    x=xx, y=yy;
    while(valid(x-1,y)) {
        x--;
        if(dp[x][y][z]>v) dp[x][y][z]=v, q.push(ms(x,y,z));
    }
    x=xx, y=yy;
    while(valid(x,y+1)) {
        y++;
        if(dp[x][y][z]>v) dp[x][y][z]=v, q.push(ms(x,y,z));
    }
    x=xx, y=yy;
    while(valid(x,y-1)) {
        y--;
        if(dp[x][y][z]>v) dp[x][y][z]=v, q.push(ms(x,y,z));
    }
}
void knight(int x, int y, ll v)
{
    if(valid(x+1,y+2) && dp[x+1][y+2][4]>v) dp[x+1][y+2][4]=v, q.push(ms(x+1,y+2,4));
    if(valid(x+1,y-2) && dp[x+1][y-2][4]>v) dp[x+1][y-2][4]=v, q.push(ms(x+1,y-2,4));
    if(valid(x+2,y+1) && dp[x+2][y+1][4]>v) dp[x+2][y+1][4]=v, q.push(ms(x+2,y+1,4));
    if(valid(x+2,y-1) && dp[x+2][y-1][4]>v) dp[x+2][y-1][4]=v, q.push(ms(x+2,y-1,4));
    if(valid(x-1,y+2) && dp[x-1][y+2][4]>v) dp[x-1][y+2][4]=v, q.push(ms(x-1,y+2,4));
    if(valid(x-1,y-2) && dp[x-1][y-2][4]>v) dp[x-1][y-2][4]=v, q.push(ms(x-1,y-2,4));
    if(valid(x-2,y+1) && dp[x-2][y+1][4]>v) dp[x-2][y+1][4]=v, q.push(ms(x-2,y+1,4));
    if(valid(x-2,y-1) && dp[x-2][y-1][4]>v) dp[x-2][y-1][4]=v, q.push(ms(x-2,y-1,4));
}
void queen(int x, int y, ll v)
{
    rook(x,y,v,5);
    bishop(x,y,v,5);
}

void calc(square sq)
{
    int b[6]; for(int i=0;i<6;i++) b[i]=i;
    b[sq.z]=0;
    ll now = dp[sq.x][sq.y][sq.z];
    if(cc[sq.x][sq.y][sq.z]==now) return;
    for(int i=1;i<=5;i++)
        if(now+b[i]<dp[sq.x][sq.y][i])
            dp[sq.x][sq.y][i]=now+b[i], q.push(ms(sq.x,sq.y,i));
    king(sq.x,sq.y,now+b[1]+1);
    bishop(sq.x,sq.y,now+b[2]+1,2);
    rook(sq.x,sq.y,now+b[3]+1,3);
    knight(sq.x,sq.y,now+b[4]+1);
    queen(sq.x,sq.y,now+b[5]+1);
    cc[sq.x][sq.y][sq.z]=dp[sq.x][sq.y][sq.z];
}

int main()
{
    ios_base::sync_with_stdio(false); cin.tie(0);
    cin >> h >> w;
    for(int i=1;i<=h;i++)
        for(int j=1;j<=w;j++) cin >> a[i][j];
    for(int i=0;i<N;i++) for(int j=0;j<N;j++)
        for(int k=0;k<6;k++) dp[i][j][k]=cc[i][j][k]=1e15;
    for(int i=1;i<=5;i++) dp[1][1][i]=i, q.push(ms(1,1,i));
    dp[1][1][1]=0;
    while(q.size()) calc(q.front()), q.pop();
    ll ans = 1e15;
    for(int i=1;i<=5;i++) ans=min(ans,dp[h][w][i]);
    cout << (ans==1e15 ? -1 : ans) << endl;
    return 0;
}